// Chrome content script for PC Express Order Scraper
console.log('Chrome content script loaded on:', window.location.href);

// Check if this is a valid order page
function isOrderPage() {
  const hasOrderHeader = document.querySelector('h1.order-dashboard-hero-time-slot') !== null;
  const hasCartEntries = document.querySelector('.order-dashboard-cart-entries') !== null;
  const hasCartItems = document.querySelector('.cart-entry__desktop-content') !== null;
  const hasOrderHistory = document.querySelector('.account-order-history-past-orders-delivery-list-item') !== null;
  
  return hasOrderHeader || hasCartEntries || hasCartItems || hasOrderHistory;
}

// Add visual indicator when extension is ready
function addPageIndicator() {
  // Remove existing indicator
  const existing = document.getElementById('pc-scraper-indicator');
  if (existing) {
    existing.remove();
  }
  
  const indicator = document.createElement('div');
  indicator.id = 'pc-scraper-indicator';
  indicator.style.cssText = `
    position: fixed;
    top: 20px;
    right: 20px;
    background: #1a73e8;
    color: white;
    padding: 10px 15px;
    border-radius: 8px;
    font-size: 13px;
    z-index: 10000;
    font-family: -webkit-body, system-ui, Arial, sans-serif;
    box-shadow: 0 4px 12px rgba(26, 115, 232, 0.3);
    border: 1px solid #1557b0;
    font-weight: 500;
  `;
  indicator.textContent = '🛒 PC Express Scraper Ready';
  
  document.body.appendChild(indicator);
  
  // Fade out and remove after 4 seconds
  setTimeout(() => {
    indicator.style.opacity = '0';
    indicator.style.transition = 'opacity 0.5s ease';
    setTimeout(() => {
      if (indicator.parentNode) {
        indicator.remove();
      }
    }, 500);
  }, 3500);
}

// Initialize when page is ready
function initializeExtension() {
  if (isOrderPage()) {
    console.log('Order page detected, showing indicator');
    addPageIndicator();
  } else {
    console.log('Not an order page');
  }
}

// Run initialization
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', initializeExtension);
} else {
  initializeExtension();
}

// Listen for dynamic content changes (if the page loads content via AJAX)
const observer = new MutationObserver((mutations) => {
  mutations.forEach((mutation) => {
    if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
      // Check if order content was added dynamically
      for (const node of mutation.addedNodes) {
        if (node.nodeType === Node.ELEMENT_NODE) {
          if (node.querySelector && 
              (node.querySelector('.order-dashboard-cart-entries') || 
               node.querySelector('h1.order-dashboard-hero-time-slot'))) {
            console.log('Order content loaded dynamically');
            addPageIndicator();
            break;
          }
        }
      }
    }
  });
});

// Start observing for dynamic content
observer.observe(document.body, {
  childList: true,
  subtree: true
});

// Message listener for popup communication
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('Content script received message:', request);
  
  if (request.action === 'checkPage') {
    const pageInfo = {
      isOrderPage: isOrderPage(),
      url: window.location.href,
      hasOrderHeader: !!document.querySelector('h1.order-dashboard-hero-time-slot'),
      hasCartEntries: !!document.querySelector('.cart-entry__desktop-content'),
      cartItemCount: document.querySelectorAll('.cart-entry__desktop-content').length
    };
    
    console.log('Page info:', pageInfo);
    sendResponse(pageInfo);
  }
  
  return true; // Keep message channel open for async response
});