// Chrome background service worker for PC Express Order Scraper
console.log('Chrome background service worker loaded');

// Extension installation/update handler
chrome.runtime.onInstalled.addListener((details) => {
  console.log('PC Express Order Scraper installed/updated:', details.reason);
  
  if (details.reason === 'install') {
    console.log('Extension installed for the first time');
    
    // Optional: Open a welcome page or show notification
    // chrome.tabs.create({
    //   url: 'https://www.nofrills.ca/en/account/order-history'
    // });
    
  } else if (details.reason === 'update') {
    console.log('Extension updated to version:', chrome.runtime.getManifest().version);
  }
});

// Handle action clicks (if popup fails to load)
chrome.action.onClicked.addListener(async (tab) => {
  console.log('Action clicked on tab:', tab.url);
  
  // This would only fire if popup fails to load
  // Normally the popup handles the interaction
  try {
    // Send message to content script as fallback
    const response = await chrome.tabs.sendMessage(tab.id, { action: 'checkPage' });
    console.log('Tab response:', response);
  } catch (error) {
    console.log('No content script available on this tab:', error);
  }
});

// Message handling for cross-extension communication
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('Background received message:', request, 'from:', sender);
  
  // Handle any background processing if needed
  if (request.action === 'processData') {
    // Could handle data processing here if needed
    sendResponse({ success: true });
  }
  
  // Return true to indicate async response
  return true;
});

// Handle download events (optional - for debugging)
chrome.downloads.onCreated.addListener((downloadItem) => {
  if (downloadItem.filename && downloadItem.filename.includes('pc_express_order_')) {
    console.log('CSV download started:', downloadItem.filename);
  }
});

chrome.downloads.onChanged.addListener((downloadDelta) => {
  if (downloadDelta.state && downloadDelta.state.current === 'complete') {
    console.log('Download completed');
  }
});